/*
emerald: my currently unused RPi 3B
*/

{ lib, ... }:

{
  imports = [ ../nixos ];

  boot.initrd.availableKernelModules = [ "usbhid" ];

  hardware.enableRedistributableFirmware = true;
  powerManagement.cpuFreqGovernor = "ondemand";

  # don't encrypt root to save resources, there's nothing critical there
  eisfunke = {
    encryption = false;
    headless = true;
    minimal = true;
    domains = [
      { domain = "eisfunke.com"; subs = [ "emerald" ]; type = "ipv6"; }
    ];
  };

  networking.hostName = "emerald";
  networking.wireless.enable = true;
  systemd.network = {
    links = {
      "10-wired0" = {
        matchConfig.PermanentMACAddress = "b8:27:eb:b1:4c:ac";
        linkConfig.Name = "wired0";
      };
      "10-wireless0" = {
        matchConfig.PermanentMACAddress = "b8:27:eb:e4:19:f9";
        linkConfig.Name = "wireless0";
      };
    };
    networks = {
      "20-wired0" = {
        name = "wired0";
        DHCP = "ipv4";

        /*
        increase priority = lower route metrics for the routes for the wired0 network
        so the wired connection is preferred over the wireless one if available
        see https://unix.stackexchange.com/questions/555500/how-to-change-the-order-of-the-default-gateway-with-systemd-networkd
        */
        dhcpV4Config = {
          RouteMetric = 1020;  # default is 1024
        };
        ipv6AcceptRAConfig = {
          RouteMetric = 508;  # default is "512:1024:2048"
        };
      };
      "20-wireless0" = {
        name = "wireless0";
        DHCP = "ipv4";
        networkConfig = {
          IgnoreCarrierLoss = "3s";
        };
      };
    };
  };

  /*
  - not really necessary on this Pi 3
  - uses unsupported UEFI firmware anyway
  - could only update HDDs
  - so I'd rather save some of the precious GB of RAM for udisks and fwupd
  */
  services.fwupd.enable = lib.mkForce false;

  system.stateVersion = "22.11";

  home-manager.users.eisfunke = {
    imports = [ ../home ];
    eisfunke = {
      deviceColor = "#027A01";  # dark green
    };
  };
}
