/*
marina: my phone

config for [nix-on-droid](https://github.com/nix-community/nix-on-droid)
*/

{ inputs, self, inputs', self', funkeLib, system, res, sshPublicKeys, pkgs, config, ... }: {
  time.timeZone = "Europe/Berlin";

  # Iosevka Funke doesn't build on NixOnDroid
  # terminal.font = "${inputs'.iosevka-funke.packages.default}/share/fonts/truetype/iosevka-funke-regular.ttf";
  terminal.font = "${pkgs.source-code-pro}/share/fonts/opentype/SourceCodePro-Regular.otf";

  user = {
    /*
    If not set, the uid / gid is obtained impurely from the device doing the build, which is
    problematic if building remotely.

    Can be obtained on the device via `id -u` and `id -g`.
    */
    uid = 10049;
    gid = 10049;

    shell = "${config.home-manager.config.programs.nushell.package}/bin/nu";
  };

  environment.motd = null;

  nix = {
    extraOptions = ''
      experimental-features = nix-command flakes ca-derivations
    '';

    # redirect nixpkgs flakes to system nixpkgs
    registry = {
      nixpkgs.flake = inputs.nixpkgs;
      nixpkgs-unstable.flake = inputs.nixpkgs-unstable;
    };
  };

  system.stateVersion = "23.05";

  home-manager = {
    useGlobalPkgs = true;
    useUserPackages = true;
    extraSpecialArgs = {
      inherit inputs self inputs' self' funkeLib system res sshPublicKeys;
    };
    config = {
      imports = [ ../home ];
      eisfunke = {
        deviceColor = "#590006";  # red
        headless = true;
        minimal = true;
        mobile = true;
      };
      nix.package = config.nix.package;  # home-manager needs to know the Nix version used
      home = {
        deploymentType = "nix-on-droid";
        groupname = "nix-on-droid";
        hostname = "marina";
        stateVersion = "23.05";
      };
      /*
      Disable checking repo owners, because on Android repos in the shared directory tree will be
      owned by root and a shared group instead of the nix-on-droid repo due to how permissions in
      Termux work.
      */
      programs.git.extraConfig.safe.directory = [ "*" ];
    };
  };
}
