/*
melissa: my desktop PC
*/

{ ... }:

{
  imports = [ ../nixos ];

  boot.initrd.availableKernelModules = [
    "igb"  # network driver to enable remote encryption unlock
  ];
  boot.kernelModules = [ "kvm-amd" ];

  /*
  Use the amd_pstate_epp frequency driver for best energy usage. The frequency governor only
  provides a hint to this driver: whether to bias towards power efficiency or performance.

  See https://wiki.archlinux.org/title/CPU_frequency_scaling
  */
  boot.kernelParams = [ "amd_pstate=active" ];
  powerManagement.cpuFreqGovernor = "performance";

  hardware.cpu.amd.updateMicrocode = true;
  hardware.enableRedistributableFirmware = true;

  # see /docs/graphics.md
  hardware.graphics.enable = true;
  hardware.amdgpu.opencl.enable = true;
  environment.variables = {
    LIBVA_DRIVER_NAME = "radeonsi";
    VDPAU_DRIVER = "radeonsi";
  };

  eisfunke.domains = [
    {
      domain = "eisfunke.com";
      subs = [ "melissa" ];
      type = "ipv6";
      /*
      - melissa uses IPv6 privacy extensions on a residential internet connection
      - so it will put that IP into DNS
      - problem is: that IP is changing regularly, so I can't open it in the firewall
      - the non-privacy-extension IP is still valid for incoming connection, so I can just put that
        into DNS
      - I do that by overwriting the interface id (i.e. the second half) in the detected public IPv6
        with the non-privacy-extension-one derived from the MAC address
      */
      ipv6OverwriteInterfaceId = "b62e:99ff:fee2:0f10";
    }
  ];

  networking.hostName = "melissa";
  systemd.network = {
    links."10-wired0" = {
      matchConfig.PermanentMACAddress = "b4:2e:99:e2:0f:10";
      linkConfig = {
        Name = "wired0";
        WakeOnLan = "magic";
      };
    };
    networks."20-wired0" = {
      name = "wired0";
      DHCP = "no";  # IPv4 is configured manually below, DNS and IPv6 via RA/SLAAC
      address = [ "10.1.1.10/16" ];
      gateway = [ "10.1.1.1" ];
      networkConfig.IPv6PrivacyExtensions = true;
    };
  };

  system.stateVersion = "22.11";

  home-manager.users.eisfunke = {
    imports = [ ../home ];
    eisfunke = {
      deviceColor = "#FA6100";  # orange
      dualBoot = true;
      displays = {
        main = {
          id = "DP-1";
          posX = 2560;
          posY = 0;
          width = 3440;
          height = 1440;
        };
        secondary = {
          id = "DP-3";
          posX = 0;
          posY = 0;
        };
        auxiliary = [ ];
      };
    };
  };
}
