#!/bin/env python3
import telepot
import argparse
from program_info import ProgramInfo

telegram_recv = "@ufcdortmund"  # kanal

# Parse Arguments
aparser = argparse.ArgumentParser(
    description="UFC Telegram Bot"
)
aparser.add_argument(
    "--doit",
    action="store_true",
    help="Sendet die Nachricht an den UFC Channel, anstatt nur eine Ausgabe zu machen"
)
aparser.add_argument(
    "--nofailmessage",
    action="store_true",
    help="Unterdrückt die Nachricht, dass kein Event gefunden wurde"
)
aparser.add_argument(
    "--dest",
    help="Alternativer Telegramchat"
)
aparser.add_argument(
    "--daydiff",
    dest='day_diff',
    type=int,
    default=1,
    help="Prüfe ob in DAY_DIFF Tagen ein Event stattfindet anstatt morgen."
)
args = aparser.parse_args()
# Überschreibe den Telegramkanal, wenn einer angegeben wurde. (Praktisch für Debugging)
if not args.dest is None:
    telegram_recv = args.dest

program_info = ProgramInfo()

next_event = program_info.get_next_event(args.day_diff)


if next_event is None:
    if not args.nofailmessage:
        print("Telegram:")
        if args.day_diff == '0':
            print("Kein Event heute.")
        elif args.day_diff == 1:
            print("Kein Event morgen.")
        else:
            print("Kein Event in " + str(args.day_diff) + " Tagen.")
    exit(1)


date = next_event.date

# Erste Nachricht zusammenbauen
message = [
    ("%s, %d. %s %d um %s Uhr im UFC:\n" % (
    date.weekday, date.day, date.month, date.year, date.time)),
    "\n",
    "*", next_event.title, "*\n",
    "\n",
    next_event.description, "" if next_event.description is "" else "\n",
    next_event.movie_description, "\n",
    "\n",
    next_event.tags, "\n",
    "\n",
    "[Link zur Veranstaltung](%s?pk_campaign=telegram)" % next_event.link
]

# Trailernachricht zusammenbauen
if next_event.trailer is not "":
    message.append("\n[Link zum Trailer](%s)" % next_event.trailer)

text = ''.join(message)

print("Vorschau Telegram:")
print(text)

# Nur abschicken, wenn es wirklich verlangt wird. Ansonsten nur in die Konsole schreiben
if args.doit is True:
    print("\nSchick Nachricht an Telegramchat " + telegram_recv)
    bot = telepot.Bot("247551569:AAHpTb4pR8Vq8FlEWYC3O8cOD2OIzQKADyQ")  # UFC-Do-Bot
    bot.sendMessage(telegram_recv, text, parse_mode="markdown", disable_web_page_preview=True)
else:
    print("\nProgramm läuft im Vorschaumodus. Es wird nichts an Telegram abgesendet.")
